unit Main;

// ====================================================================
(*
           TCP/IP 
                 

    TCP/IP      
   ,         .
        
        ()  .
    ,       
     .   
            Ecxel,
          
    .    ()  
       .
   // -----------------------------------------------------
    2.01. ()  , , , , 2018.
                () Source code  ..
     08.01.2018
*)
// ====================================================================

// ====================================================================
//     INDY
// ====================================================================

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, MMSystem, StrUtils, StdCtrls, ExtCtrls, ComCtrls,
  //
  IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  //
  Common1, AppDispatch1,
  UserApp01Main, UserApp02Main, UserApp03Main, UserApp04Main;

type
  TClientForm = class(TForm)
    TCPClient: TIdTCPClient;
    Timer1: TTimer;
    Timer2: TTimer;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    edIP: TEdit;
    edPort: TEdit;
    Button1: TButton;
    Button2: TButton;
    stxtConnect: TStaticText;
    edName: TEdit;
    edPSW: TEdit;
    StatusBar1: TStatusBar;
    Button4: TButton;
    cbBoxCMD: TComboBox;
    Button3: TButton;
    cboBoxReadTimer: TComboBox;
    Label10: TLabel;
    edTimerValue: TEdit;
    Label11: TLabel;
    Label1: TLabel;
    Memo1: TMemo;
    procedure TCPClientConnected(Sender: TObject);
    procedure TCPClientDisconnected(Sender: TObject);
    procedure TCPClientStatus(ASender: TObject;
      const AStatus: TIdStatus; const AStatusText: String);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button4Click(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure edTimerValueChange(Sender: TObject);

  private
    { Private declarations }
    //     
    function TryWriteLn(Msg : string) : boolean;
    //     
    function TryReadLn(var Msg : string) : boolean;
    //     
    function TryReadBuffer(var   ABuffer;
                           const AByteCount: Integer;
                           var   SatusStr : string) : boolean;
    //   
    function DoDisConnect(Msg : string) : boolean;
    //     
    procedure RunRequest(RqCmdInd : integer);

  public
    { Public declarations }
  end;

var
  ClientForm: TClientForm;

// ==========================================================================
// ==========================================================================

implementation
{$R *.dfm}

// ==========================================================================
// ==========================================================================

// ==========================================================================
//   
// ==========================================================================
// ------------------------------
//     
const cRepTimeOut = 20;         //      
      cFieldSep   = ':';        //      
      cRepYES     = 'YES';      //     
      cRepNOT     = 'NOT';      //     
      cCmdEND     = 'END';      //    
// -----------------------------
//   
const cCmdConnect    = 'CNN';   //     
      cCmdDisConnect = 'DCN';   //     
      cCmdLink       = 'LNK';   //      
      cCmdService    = 'SRV';   //      
// -----------------------------
//   
const cCmdGET       = 'GET';    //    
      cCmdSET       = 'SET';    //      

// -----------------------------
//     
// -----------------------------
//      ( 1 msec)
//    unit MMSystem.pas
type TTimeStampsMM = record
  MMErr  : word;             //      
  BTime  : LongInt;          //    msec
  ETime  : LongInt;          //    msec
end;

// ==========================================================================
//   
// ==========================================================================
// -------------------------------------------------------------------------
//    
function GetApplicationDirectory() : string;
begin
   Result := Application.ExeName;
   Result := ExtractFileDir(Result);
end;
// --------------------------------------------------------------------------
//  Login-  
function GetCurrentUserName() : string;
const  cnMaxUserNameLen = 254;
var   sUserName     : string;
      dwUserNameLen : DWord;
begin
  dwUserNameLen := cnMaxUserNameLen-1;
  SetLength( sUserName, cnMaxUserNameLen );
  GetUserName(
    PChar( sUserName ),
    dwUserNameLen );
  SetLength( sUserName, dwUserNameLen );
  Result := sUserName;
end;
// --------------------------------------------------------------------------
//  RqEdit.Text     
function TryEditToInt(RqEdit : TEdit; var Value : integer) : boolean;
begin
   Result := False;
   try
       if Trim(RqEdit.Text) = ''
       then Value := 0
       else begin
           Value := StrToInt(Trim(RqEdit.Text));
           RqEdit.Color := clWindow;
       end;
       Result := True;
   except
       RqEdit.Color := RGB(255,240,240);
       ShowMessage('       ');
   end;
end;
// --------------------------------------------------------------------------
// 24.11.2016
//      
//  1
//   Cmd = 'field1:field2:field3'
//   Result = 'field1', Cmd = 'field2:field3'
//  2
//   Cmd = 'field3'
//   Result = 'field3', Cmd = ''
function CutNextCmdField(var Cmd : string) : string;
var wPos : integer;
    wStr : string;
begin
   wStr   := Trim(Cmd);
   Result := wStr;
   wPos   := pos(cFieldSep, wStr);
   if wPos > 0
   then begin
        Result := copy(wStr, 1, wPos - 1);
        if (Length(wStr) > wPos)
        then Cmd := copy(wStr, wPos + 1, Length(wStr))
   end
   else Cmd := '';
end;
// =========================================================================
//       
// =========================================================================
// 10.03.2013
//    
procedure StartMMTimeStamp (var RqStamp  : TTimeStampsMM);
begin
   try
       RqStamp.BTime := timeGetTime;
       RqStamp.MMErr := 0;
   except
       RqStamp.MMErr := 1;          //   
   end;
end;
// -------------------------------------------------------------------------
// 10.03.2013
//       
function StopMMTimeStamp (var RqStamp  : TTimeStampsMM) : string;
begin
   if RqStamp.MMErr = 0
   then begin
      with RqStamp
      do begin
          try
            ETime := timeGetTime;
            if (ETime - BTime) >= 0
            then Result := IntToStr(ETime - BTime);
          except
            MMErr := 1;
            Result := '-1';
          end;
      end;
   end
   else Result := '-1';
end;
// ==========================================================================
//   TRY-     
// ==========================================================================
// --------------------------------------------------------------------------
// 24.11.2016
//     
function TClientForm.TryWriteLn(Msg : string) : boolean;
begin
   try
     TCPClient.WriteLn(Msg);
     Result := True;
   except
     Result := False;
   end;
end;
// --------------------------------------------------------------------------
// 24.11.2016
//     
function TClientForm.TryReadLn(var Msg : string) : boolean;
var RepeatCount : integer;
begin
   RepeatCount := 10;  //  
   Msg := '';
   try
     repeat
        Msg := TCPClient.ReadLn('', cRepTimeOut);
        Dec(RepeatCount);
     until ((Msg <> '') or (RepeatCount < 0));
     //  Msg <> ''    //    
     //  Msg  = ''    //   
     Result := True;
   except
     //      
     Result := False;
   end;
end;
// --------------------------------------------------------------------------
// 06.12.2016
//     
function TClientForm.TryReadBuffer(var ABuffer;
                            const AByteCount: Integer;
                            var SatusStr : string) : boolean;
const TimeOut = 10000;             // 10 .    60 .
var TimeStampsMM : TTimeStampsMM;  //    
begin
  Result := False;
  if (AByteCount > 0) and (@ABuffer <> nil)
  then begin
    StartMMTimeStamp(TimeStampsMM);
    with TCPClient
    do begin
      //   
      while (InputBuffer.Size < AByteCount)
      do begin
        try
          try
             //  
             ReadFromStack(True,TimeOut,True);
          except
             SatusStr := ' GET : , TimeOut';
             Exit;
          end;
          //   
          CheckForDisconnect(True, True);
        except
            SatusStr := ' GET : , Disconnect';
            Exit;
        end;
      end;
      // Copy it to the callers buffer
      Move(InputBuffer.Memory^, ABuffer, AByteCount);
      // Remove used data from buffer
      InputBuffer.Remove(AByteCount);
      // ---------------------------
      SatusStr := ' GET :  : '
                + StopMMTimeStamp(TimeStampsMM) + ' msec.';
      Result := True;
    end;
  end;
end;
// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
// 07.01.2017
//   
function TClientForm.DoDisConnect(Msg : string) : boolean;
begin
   Result := False;
   //         
   Timer1.Enabled := False;
   //  Disconnect
   if TCPClient.Connected
   then begin
      //     - " "
      TryWriteLn(cCmdDisConnect);
   end;
   //   (  TCPClient.Connected )
   try
     TCPClient.Disconnect();
     StatusBar1.Panels[1].Text := Msg;
     Result := True;
   except
     StatusBar1.Panels[1].Text := 'ERROR :   '
                                + ' ';
   end;
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   - " Disconnect"
procedure TClientForm.TCPClientDisconnected(Sender: TObject);
begin
  //   Online
  stxtConnect.Color := clBtnFace;
  //   
  Memo1.Clear;
  Memo1.Lines.Add(' ');
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   DisConnect   
procedure TClientForm.Button2Click(Sender: TObject);
begin
  //  
  DoDisConnect('   ');
end;
// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
// 07.01.2017
//      
procedure TClientForm.Timer1Timer(Sender: TObject);
var   wCmd     : string;
      wRep     : string;
      wYesNot  : string;   //  
begin
  // ---------------------------------------
  //    ,    
  if TCPClient.Connected
  then begin
     if TryReadLn(wRep)
     then begin
         if wRep <> ''
         then begin
            //    ,   
            wCmd  := CutNextCmdField(wRep);
            if wCmd = cCmdEND
            then begin
              //     
              DoDisConnect('    : ' + cCmdEND);
              Exit;
            end;
         end;
     end
     else begin
       //       
       DoDisConnect('      ');
       Exit;
     end;
  end;
  // ---------------------------------------
  //      
  if TCPClient.Connected
  then begin
     //     
     if not TryWriteLn(cCmdLink)
     then begin
        //        
        DoDisConnect('     : ' + cCmdLink);
        Exit;
     end
     else begin
        //      -  
        if TryReadLn(wRep)
        then begin
           if wRep = ''
           then begin
              //  
              DoDisConnect(cCmdLink
                        + ' :      ');
              Exit;
           end
           else begin
              //   
              wYesNot := CutNextCmdField(wRep);
              if wYesNot = cRepYES
              then begin
                 //   
                 //      
                 Exit;
              end;
           end;
        end
        else begin
          //       
          DoDisConnect(cCmdLink
                  + ' :       ');
          Exit;
        end;
     end;
  end;
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   - " Connect"
procedure TClientForm.TCPClientConnected(Sender: TObject);
var   wCmd   : string;
      wOp    : string;
begin
   //  
   wCmd := cCmdConnect + cFieldSep + edName.Text + cFieldSep + edPSW.Text;
   if not TryWriteLn(wCmd)
   then begin
      StatusBar1.Panels[1].Text := '     : '
                                  + cCmdConnect;
      Exit;
   end;
   //    
   if TryReadLn(wCmd)
   then begin
         //  
         wOp  := CutNextCmdField(wCmd);
         if wOp = ''
         then begin
           DoDisConnect('  ');
           Exit;
         end;
         if wOp = cRepYES
         then begin
           Timer1.Enabled := True;
           StatusBar1.Panels[1].Text := '  ';
           stxtConnect.Color := clLime;
           Memo1.Clear;
           Memo1.Lines.Add(' ');
           Exit;
         end;
         if wOp = cRepNOT
         then begin
           DoDisConnect('   ');
           Exit;
         end;
   end
   else begin
      DoDisConnect('ERROR :       ');
   end;
end;
// --------------------------------------------------------------------------
//   -   
procedure TClientForm.Button1Click(Sender: TObject);
begin
  if (edIP.Text   = '') or
     (edPort.Text = '') or
     (edName.Text = '') or
     (edPSW.Text  = '')
  then begin
     StatusBar1.Panels[1].Text := '     ';
     Exit;
  end;
  TCPClient.Host := edIP.Text;
  TCPClient.Port := StrToInt(edPort.Text);
  try
    TCPClient.Connect();
  except
    StatusBar1.Panels[1].Text := '    : Connect';
  end;
end;
// --------------------------------------------------------------------------
// 07.01.2017
//   -    
procedure TClientForm.TCPClientStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: String);
begin
  StatusBar1.Panels[0].Text := AStatusText;
end;

// ==========================================================================
//    
// ==========================================================================
// --------------------------------------------------------------------------
// 07.01.2017
//     
procedure TClientForm.RunRequest(RqCmdInd : integer);
var  wRequest : TRequest;  //     
     wCmd     : string;    //    
     wRep     : string;    //   
begin
    // ----------------------------
    //  
    if not TCPClient.Connected
    then begin
       StatusBar1.Panels[1].Text := '     ';
       Exit;
    end;
    // ----------------------------
    //      
    if not SetRequest(RqCmdInd, wRequest)
    then begin
       StatusBar1.Panels[1].Text := '  ';
       Exit;
   end;
   // ----------------------------
   //  
   wCmd := '';
   wRep := '';
   StatusBar1.Panels[1].Text :='';
   Memo1.Clear;
   // ----------------------------
   //     
   wCmd := cCmdService
           + cFieldSep + Trim(wRequest.RqCmd)
           + cFieldSep + Trim(wRequest.RqPrm);
   // ----------------------------
   //    
   if not TryWriteLn(wCmd)
   then begin
      StatusBar1.Panels[1].Text := '     : '
                                    + wCmd;
      Exit;
   end;
   // ----------------------------
   //    
   if TryReadLn(wRep)
   then begin
      wRequest.Replay := wRep;
      //   
      if wRep = ''
      then begin
         DoDisConnect('     ');
         Exit;
      end;
      //   
      wRep := CutNextCmdField(wRep);
      //  
      if wRep = cRepNOT
      then begin
           StatusBar1.Panels[1].Text := '  '
                                      + '   : '
                                      + wCmd;
           Exit;
      end;
      //     
      if wRep = cRepYES
      then begin
           if (wRequest.RqCmd = 'GET') and
              (wRequest.Buffer <> nil) and
              (wRequest.BufSize > 0)
           then begin
              // ----------------------------
              //   
              if TryReadBuffer(wRequest.Buffer^,
                               wRequest.BufSize,
                               wRep)
              then begin
                 ShowResult(wRequest, Memo1);
              end
              else begin
                 Memo1.Lines.Add(' c ReadBuffer');
              end;
           end;
           if (wRequest.RqCmd = 'SET')
           then begin
              //     SET  
           end;
           //    
           StatusBar1.Panels[1].Text := wRep;
      end;
   end;
   //      
   Memo1.Lines.Add(wRep);
   Memo1.Lines.Add (DupeString('-', 80));
end;

// ==========================================================================
//   
// ==========================================================================
// --------------------------------------------------------------------------
// 07.01.2017
//      
procedure TClientForm.Button3Click(Sender: TObject);
begin
   RunRequest(cbBoxCMD.ItemIndex);
end;
// --------------------------------------------------------------------------
// 16.01.2017
//   
procedure TClientForm.Timer2Timer(Sender: TObject);
begin
   if cboBoxReadTimer.ItemIndex = 1
   then RunRequest(cbBoxCMD.ItemIndex);
end;
// --------------------------------------------------------------------------
// 16.01.2017
//    
procedure TClientForm.edTimerValueChange(Sender: TObject);
var Value : integer;
begin
   if TryEditToInt(edTimerValue, Value)
   then begin
      Timer2.Enabled := False;
      if Value < 20
      then begin
         Timer2.Interval := 20;
         edTimerValue.Text := '20';
      end
      else Timer2.Interval := Value;
      Timer2.Enabled := True;
   end;
end;

// ==========================================================================
//   / 
// ==========================================================================
// --------------------------------------------------------------------------
// 
procedure TClientForm.FormCreate(Sender: TObject);
begin
  //    
  ApplicationDirectory := GetApplicationDirectory();
  //    
  edName.Text := GetCurrentUserName();
end;

// --------------------------------------------------------------------------
//     
procedure TClientForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if TCPClient.Connected
  then begin
    Action := caNone;
    MessageDlg('    '
    + #13#10 + '  ( Online )...',
               mtInformation, [mbOk], 0);
  end;
end;

// --------------------------------------------------------------------------
//    (  )
procedure TClientForm.Button4Click(Sender: TObject);
begin
   case cbBoxCMD.ItemIndex of
     0 : UserApp01Form.Show;
     1 : UserApp02Form.Show;
     2 : UserApp03Form.Show;
     3 : UserApp04Form.Show;
   end;
end;

// ==========================================================================
// 
// ==========================================================================
end.
